/**
* \file: WaylandTouchListener.h
*
* \version: 0.3
*
* \release: $Name:$
*
* Handles touch events coming from Wayland
*
* \component: Unified SPI
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef USPI_WL_TOUCH_LISTENER_H
#define USPI_WL_TOUCH_LISTENER_H

#include <wayland-client-protocol.h>

namespace adit { namespace uspi {

class ITouchFacadeCallbacks;

/** @class  WaylandTouchListener
 *  @brief  Listener to catch the touch events from Wayland
 */
class WaylandTouchListener
{
public:
    static wl_touch_listener mWlTouchListener;

    WaylandTouchListener(ITouchFacadeCallbacks& inCallbacks, int inDisplayWidth, int inDisplayHeight, int inFingerNum);
    virtual ~WaylandTouchListener();

    void setLateResolution(int inWidth, int inHeight);

private:
    ITouchFacadeCallbacks& mCallbacks;

    // todo mDisplayWidth/Height will be asked within the event handlers
    int mDisplayWidth;
    int mDisplayHeight;

    int mMaxFingerNum;

    /* Wayland touch event handlers */
    static void onDown(void* inMe, wl_touch* inTouch, uint32_t inEventSerial, uint32_t inTimestamp,
            wl_surface* inWlSurface, int32_t inFingerId, wl_fixed_t inPixelX, wl_fixed_t inPixelY);

    static void onUp(void* inMe, wl_touch* inTouch, uint32_t inEventSerial, uint32_t inTimestamp, int32_t inFingerId);

    static void onMotion(void* inMe, wl_touch* inTouch, uint32_t inTimestamp, int32_t inFingerId, wl_fixed_t inPixelX,
            wl_fixed_t inPixelY);

    static void onFrame(void* inMe, wl_touch* inTouch);

    static void onCancel(void* inMe, wl_touch* inTouch);
};

} } /* namespace adit { namespace uspi { */

#endif /* USPI_WL_TOUCH_LISTENER_H */
